/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class HeatRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final List<HeatRecipe> recipeList = new ArrayList<HeatRecipe>();

    public void clearRecipes() {
        this.recipeList.clear();
    }

    public int getHeatAmount(@Nonnull BlockState entry) {
        return this.recipeList.stream().filter(recipe -> recipe.isMatch(entry)).findFirst().map(HeatRecipe::getAmount).orElse(0);
    }

    @Nonnull
    public List<HeatRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<HeatRecipe> recipes) {
        logger.debug("Heat Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }
}

